/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMArrivalsTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_TYPE = 0;
    public static final int COL_NAME = 1;
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_PRODUCTION = 1;
    private static int s_arrivalNameCount = 0;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_rowData = null;
    private VWScenarioWorkflowDefinition m_wfDef = null;

    public VWSIMArrivalsTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public void addItem() {
        VWScenarioArrivalDefinition arrivalDef = null;
        try {
            if (this.m_wfDef != null) {
                String name = null;
                boolean success = false;
                while (!success) {
                    name = VWSIMResource.s_arrival + ++s_arrivalNameCount;
                    try {
                        VWScenarioTimeDuration duration = new VWScenarioTimeDuration("0", 3);
                        VWScenarioArrivalOccurrence occurrence = new VWScenarioArrivalOccurrence(1, "0", null, duration, null);
                        VWScenarioTimeDuration startDuration = new VWScenarioTimeDuration("0", 3);
                        arrivalDef = this.m_wfDef.createArrival(name, startDuration, occurrence, null, null);
                        this.m_propertyData.setDirty();
                        success = true;
                    }
                    catch (Exception ex) {}
                }
                this.m_rowData.addElement(arrivalDef);
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changeItemType(int nType, int nRowIndex) {
        try {
            Object arrival = this.getItemAt(nRowIndex);
            if (arrival != null) {
                String name = null;
                Object startTime = null;
                if (arrival instanceof VWScenarioArrivalDefinition) {
                    VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrival;
                    name = arrivalDef.getName();
                    startTime = arrivalDef.getStartTime();
                } else if (arrival instanceof VWScenarioArrivalPattern) {
                    VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)arrival;
                    name = arrivalPattern.getName();
                    startTime = arrivalPattern.getStartTime();
                }
                int nIndex = this.m_rowData.indexOf(arrival);
                this.m_wfDef.deleteArrival(name);
                switch (nType) {
                    case 0: {
                        VWScenarioTimeDuration duration = new VWScenarioTimeDuration("0", 3);
                        VWScenarioArrivalOccurrence occurrence = new VWScenarioArrivalOccurrence(1, "0", null, duration, null);
                        VWScenarioArrivalDefinition arrivalDef = this.m_wfDef.createArrival(name, startTime, occurrence, null, null);
                        this.m_rowData.setElementAt(arrivalDef, nIndex);
                        break;
                    }
                    case 1: {
                        Calendar start = Calendar.getInstance();
                        start.set(10, 8);
                        start.set(12, 0);
                        start.set(9, 0);
                        Calendar end = Calendar.getInstance();
                        end.set(10, 5);
                        end.set(12, 0);
                        end.set(9, 1);
                        VWScenarioArrivalPattern arrivalPattern = this.m_wfDef.createArrival(name, startTime, start.getTime(), end.getTime(), 0.0f, "eProcess");
                        this.m_rowData.setElementAt(arrivalPattern, nIndex);
                        break;
                    }
                }
                this.m_propertyData.setDirty();
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copyItem(int nRowIndex) {
        try {
            Object arrival = this.getItemAt(nRowIndex);
            if (arrival != null) {
                if (arrival instanceof VWScenarioArrivalDefinition) {
                    VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrival;
                    Object newArrivalDef = this.m_wfDef.createArrival(VWSIMResource.s_copyOf + " " + arrivalDef.getName(), arrival);
                    this.m_rowData.addElement(newArrivalDef);
                } else if (arrival instanceof VWScenarioArrivalPattern) {
                    VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)arrival;
                    Object newArrivalPattern = this.m_wfDef.createArrival(VWSIMResource.s_copyOf + " " + arrivalPattern.getName(), arrival);
                    this.m_rowData.addElement(newArrivalPattern);
                }
                this.m_propertyData.setDirty();
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            Object arrival = this.getItemAt(nRowIndex);
            if (arrival != null) {
                if (arrival instanceof VWScenarioArrivalDefinition) {
                    VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrival;
                    this.m_wfDef.deleteArrival(arrivalDef.getName());
                } else if (arrival instanceof VWScenarioArrivalPattern) {
                    VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)arrival;
                    this.m_wfDef.deleteArrival(arrivalPattern.getName());
                }
                this.m_rowData.removeElement(arrival);
                this.m_propertyData.setDirty();
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public Object getItemAt(int nRowIndex) {
        int nRowDataCount = this.m_rowData.size();
        if (nRowDataCount > 0 && nRowIndex >= 0 && nRowIndex < nRowDataCount) {
            return this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public void reinitialize(Object[] arrivalDefs, VWScenarioWorkflowDefinition wfDef) {
        int arrivalCount;
        s_arrivalNameCount = 0;
        this.m_wfDef = wfDef;
        this.m_rowData.removeAllElements();
        if (arrivalDefs != null && (arrivalCount = arrivalDefs.length) > 0) {
            try {
                VWQubbleSort qubbleSort = new VWQubbleSort();
                VWQubbleSort.sort(arrivalDefs);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            for (int i = 0; i < arrivalCount; ++i) {
                this.m_rowData.addElement(arrivalDefs[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Object.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        String resultString = null;
        switch (column) {
            case 0: {
                resultString = "";
                break;
            }
            case 1: {
                resultString = VWSIMResource.s_name;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            Object arrivalDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    return arrivalDef;
                }
                case 1: {
                    if (arrivalDef instanceof VWScenarioArrivalDefinition) {
                        VWScenarioArrivalDefinition arrival = (VWScenarioArrivalDefinition)arrivalDef;
                        return arrival != null ? arrival.getName() : new String("");
                    }
                    if (!(arrivalDef instanceof VWScenarioArrivalPattern)) break;
                    VWScenarioArrivalPattern arrival = (VWScenarioArrivalPattern)arrivalDef;
                    return arrival != null ? arrival.getName() : new String("");
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 1: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            String name = (String)aValue;
            if (name != null && name.length() > 0) {
                Object arrival = this.getItemAt(nRowIndex);
                if (arrival instanceof VWScenarioArrivalDefinition) {
                    VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrival;
                    arrivalDef.setName(name);
                } else if (arrival instanceof VWScenarioArrivalPattern) {
                    VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)arrival;
                    arrivalPattern.setName(name);
                }
                this.m_propertyData.setDirty();
                this.fireTableCellUpdated(nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

